


/**
 ******************************************************************************
 *
 * @file        MG32_Button_API.c
 * @brief       Button handle C code file.
 
 * @par         Project
 *              Mouse
 * @version     V1.00
 * @date        2022/03/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
/* Includes ------------------------------------------------------------------*/
#include "MG32_Common_API.h"
#include "MG32_Button_API.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
const static uint32_t ButtonPortDefine[BTN_Total]=
{
    GPIOC_Base,         //L   Port
    GPIOC_Base,         //R   Port
    GPIOC_Base,         //M   Port
    GPIOC_Base,         //BW  Port
    GPIOC_Base,         //FW  Port
};

const static uint8_t ButtonPinDefine[BTN_Total]= 
{
    8,          //L   Pin
    9,          //R   Pin
    10,         //M   Pin
    11,         //BW  Pin
    12,         //FW  Pin
};

BTNCTR_TypeDef   BTN_CTR;

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/ 

/**
 *******************************************************************************
 * @brief	   Button initial
 * @details     
 * @return      
 * @exception  No 
 * @note
 *******************************************************************************
 */ 
void API_Button_Init(void)
{
    uint8_t          API_BTN_InitTmp;

    
    /*GPIO initial*/
    GPIO_PinConfig(   BTN_L_IOM_PIN, Data_DIR_IN_RU, BTN_L_IOM_AFS);
    GPIO_PinConfig(   BTN_R_IOM_PIN, Data_DIR_IN_RU, BTN_R_IOM_AFS);
    GPIO_PinConfig(   BTN_M_IOM_PIN, Data_DIR_IN_RU, BTN_M_IOM_AFS);
    GPIO_PinConfig(  BTN_BW_IOM_PIN, Data_DIR_IN_RU, BTN_BW_IOM_AFS);
    GPIO_PinConfig(  BTN_FW_IOM_PIN, Data_DIR_IN_RU, BTN_FW_IOM_AFS);
    
    /*Parameter initial*/
    for(API_BTN_InitTmp = 0; API_BTN_InitTmp < BTN_Total; API_BTN_InitTmp++)
    {
        BTN_CTR.ButtonStatus[API_BTN_InitTmp]      = 0;
        BTN_CTR.ButtonDebounceCnt[API_BTN_InitTmp] = 0;
    }
    BTN_CTR.Button_ChangeFlag = 0;
}
/**
 *******************************************************************************
 * @brief	   Detect Button status.
 * @details     
 * @return      
 * @exception  No 
 * @note
 *******************************************************************************
 */
void API_Button_GetStatus(void)
{
    uint8_t API_MS_GetBTStatusTmp;
    uint8_t API_MS_GetBTStatusDataTmp;
    uint8_t API_MS_GetBTStatusFlagTmp;
    
    API_MS_GetBTStatusFlagTmp = 0;
    
    for(API_MS_GetBTStatusTmp = 0; API_MS_GetBTStatusTmp < BTN_Total; API_MS_GetBTStatusTmp++)
    {
        /*Detect Pin status now*/
        API_MS_GetBTStatusDataTmp = PX( ButtonPortDefine[API_MS_GetBTStatusTmp], ButtonPinDefine[API_MS_GetBTStatusTmp]);
        API_MS_GetBTStatusDataTmp = (~API_MS_GetBTStatusDataTmp) & 0x01;
        
        /*Compare Pin previous status*/
        if( API_MS_GetBTStatusDataTmp != BTN_CTR.ButtonStatus[API_MS_GetBTStatusTmp])
        {
            BTN_CTR.ButtonDebounceCnt[API_MS_GetBTStatusTmp]++;
        }
        else
        {
            BTN_CTR.ButtonDebounceCnt[API_MS_GetBTStatusTmp] = 0;
        }
        /*Debounce handle*/
        if( BTN_CTR.ButtonDebounceCnt[API_MS_GetBTStatusTmp] == BTN_DebounceTime)
        {
            BTN_CTR.ButtonStatus[API_MS_GetBTStatusTmp] = API_MS_GetBTStatusDataTmp;
            
            API_MS_GetBTStatusFlagTmp = 1;
        }
    }
    
    if( API_MS_GetBTStatusFlagTmp!=0)
    {
        BTN_CTR.Button_ChangeFlag = 1;
    }
}




